package gov.va.genisis2.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.ICommentHistoryDao;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.service.ICommentHistoryService;

/**
 * @author 586338
 * @author Getaneh Kassahun
 *
 */
@Service
public class CommentHistoryService implements ICommentHistoryService {
	/**
	 * The commentHistoryDao
	 * 
	 */
	/**
	 * The LOGGER.
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(CommentHistoryService.class);
	
	@Autowired
	private ICommentHistoryDao commentHistoryDao;

	/**
	 * This method is used to createCommentHistory.
	 * 
	 * @param commentHistory
	 *            The commentHistory.
	 * @return int This returns commentHistory id.
	 * 
	 */
	@Override
	public int createCommentHistory(CommentHistory commentHistory) throws GenisisServiceException {
		try {
			return commentHistoryDao.createCommentHistory(commentHistory);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on createCommentHistory", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to updateCommentHistory.
	 * 
	 * @param commentHistory
	 *            The commentHistory.
	 * @return int This returns CommentHistory id.
	 * 
	 */
	@Override
	public int updateCommentHistory(CommentHistory commentHistory) throws GenisisServiceException {
		try {
			return commentHistoryDao.updateCommentHistory(commentHistory);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on updateCommentHistory", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getCommentHistoriesByID.
	 * 
	 * @param id
	 *            The id.
	 * @return CommentHistory This returns CommentHistory.
	 * 
	 */
	
	/*public CommentHistory getCommentHistoriesByID(int id) throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistoriesByID(id);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistoriesByID", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}*/

	/**
	 * This method is used to getCommentHistoriesByUID.
	 * 
	 * @param uid
	 *            The uid.
	 * @return this returns list of CommentHistories .
	 * 
	 */
	@Override
	public List<CommentHistory> getCommentHistoriesByUID(String uid) throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistoriesByUID(uid);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistoriesByUID", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getCommentHistories.
	 * 
	 * @return this returns list of CommentHistories .
	 * 
	 */
	/*@Override
	public List<CommentHistory> getCommentHistories() throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistories();
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistories", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}*/

	/**
	 * This method is used to submitOrModify.
	 * 
	 * @param commentHistory
	 *            The commentHistory.
	 * @return int This returns list of CommentHistory id .
	 * 
	 */
	@Override
	public int submitOrModify(CommentHistory commentHistory) throws GenisisServiceException {
		try {
			return commentHistoryDao.submitOrModify(commentHistory);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on submitOrModify", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getCommentHistoryById.
	 * 
	 * @param requestId
	 *            The requestId.
	 * @return this returns list of CommentHistories .
	 * 
	 */
	@Override
	public List<CommentHistory> getCommentHistoryById(int requestId) throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistoryById(requestId);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistoryById", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getCommentHistoryByCommentId.
	 * 
	 * @param commentId
	 *            The commentId.
	 * @return CommentHistory This returns CommentHistory.
	 * 
	 */
	@Override
	public CommentHistory getCommentHistoryByCommentId(int commentId) throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistoryByCommentId(commentId);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistoryByCommentId", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

	/**
	 * This method is used to getCommentHistoryByRequestIdStatusId.
	 * 
	 * @param requestId
	 *            The requestId.
	 * @param taskId
	 *            The taskId.
	 * @return this returns list of CommentHistories.
	 * 
	 */
	@Override
	public List<CommentHistory> getCommentHistoryByRequestIdStatusId(int requestId, String taskId) throws GenisisServiceException {
		try {
			return commentHistoryDao.getCommentHistoryByRequestIdStatusId(requestId, taskId);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getCommentHistoryByRequestIdStatusId", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}
	
	/**
	 * @param commentHistoryDao the commentHistoryDao to set
	 */
	public void setCommentHistoryDao(ICommentHistoryDao commentHistoryDao) {
		this.commentHistoryDao = commentHistoryDao;
	}
}
